/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.upgrddat;

import com.ibm.hwmca.base.upgrddat.UpgradeDataConstants;
import com.ibm.hwmca.base.upgrddat.UpgradeDataErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class UpgradeDataRestoreOS2
implements UpgradeDataErrorIds,
UpgradeDataConstants {
    private static final String TRACE_MASKT = "XSAVOS2T";
    private static final String TRACE_MASKF = "XSAVOS2F";
    private static final String TRACE_MASKD = "XSAVOS2D";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeDataRestoreOS2");
    public final String traceFileName = "UpgradeDataTrace.lst";
    private String filePrefix = "UpgradeData.";
    protected String file;
    protected String versionNumber;
    protected String traceFile;
    private boolean critical_error_flag = false;

    public UpgradeDataRestoreOS2() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataRestoreOS2() Constructor");
        try {
            this.file = "UpgradeOS2.trm";
            this.file = BaseFileControl.getFilePath("UpgradeOS2.trm") + "UpgradeOS2.trm";
            this.traceFile = BaseFileControl.getFilePath("UpgradeDataTrace.lst") + "UpgradeDataTrace.lst";
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, "An Exception occurred finding pathing for table file");
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexe = new UpgradeDataException(exc);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16560, hexe).log();
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataRestoreOS2() Constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int restoreOS2UpgradeData() throws UpgradeDataException {
        int status = 0;
        byte[] readBuffer = new byte[4096];
        Trace.trace(TRACE_MASKT, "-> UpgradeDataRestoreOS2.restoreOS2UpgradeData()");
        Trace.trace(TRACE_MASKT, "UpgradeDataRestoreOS2.restoreOS2UpgradeData Linux Restore");
        try {
            try {
                Date date = new Date();
                FileWriter fileTrace = new FileWriter(this.traceFile, true);
                fileTrace.write("\n\nUpgradeDataRestoreOS2 Restore OS2 to Linux running\n");
                fileTrace.write("\n" + date + "\n\n");
                Trace.trace(TRACE_MASKF, "upgradePath is : /mnt/upgrade/linos2/");
                fileTrace.write("upgradePath is /mnt/upgrade/linos2/ \n");
                Trace.trace(TRACE_MASKF, "using table file " + this.file + ".");
                fileTrace.write("Table name being used is : " + this.file + "\n\n");
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                String line = null;
                Object newFileName = null;
                do {
                    UpgradeDataException hexe;
                    if ((line = in.readLine()) == null || (line = line.trim()).length() <= 0 || line.substring(0, 1).equals("#") || line.substring(0, 1).equals("!")) continue;
                    StringTokenizer parser = new StringTokenizer(line);
                    String file_name = null;
                    String directory_name = null;
                    String class_name = null;
                    String method_name = null;
                    int token_count = parser.countTokens();
                    UpgradeData userClass = null;
                    Object is = null;
                    try {
                        String fullFileName;
                        String[] foundFiles;
                        block41: {
                            Trace.trace(TRACE_MASKF, "Number of tokens is " + token_count);
                            file_name = parser.nextToken();
                            directory_name = parser.nextToken();
                            class_name = parser.nextToken();
                            if (token_count == 4) {
                                method_name = parser.nextToken();
                            }
                            Trace.trace(TRACE_MASKF, "file name is " + file_name);
                            Trace.trace(TRACE_MASKF, "directory name is " + directory_name);
                            Trace.trace(TRACE_MASKF, "class name is " + class_name);
                            Trace.trace(TRACE_MASKF, "method name is " + method_name);
                            File fpath = new File("/mnt/upgrade/linos2/" + directory_name);
                            if (fpath.exists()) {
                                Trace.trace(TRACE_MASKF, "Sub directory /mnt/upgrade/linos2/" + directory_name + " exists");
                                if (token_count == 3) {
                                    userClass = (UpgradeData)Class.forName(class_name).newInstance();
                                    Trace.trace(TRACE_MASKF, "class [" + class_name + "] created.");
                                } else {
                                    Trace.trace(TRACE_MASKF, "Start class [" + class_name + "].");
                                    Class<?> singleClass = Class.forName(class_name);
                                    Trace.trace(TRACE_MASKF, "Start method [" + method_name + "].");
                                    Method singleMethod = singleClass.getMethod(method_name, null);
                                    Trace.trace(TRACE_MASKF, "Start method done.");
                                    userClass = (UpgradeData)singleMethod.invoke(null, null);
                                    Trace.trace(TRACE_MASKF, "invoke method done.");
                                    Trace.trace(TRACE_MASKF, "class [" + method_name + "] created.");
                                }
                                foundFiles = new String[1];
                                fullFileName = null;
                                int global_offset = file_name.indexOf("*");
                                Trace.trace(TRACE_MASKF, "global offset is : " + global_offset);
                                if (global_offset < 0) {
                                    Trace.trace(TRACE_MASKF, "No global * found ");
                                    fpath = new File("/mnt/upgrade/linos2/" + directory_name + "/" + file_name);
                                    Trace.trace(TRACE_MASKF, "full file name is /mnt/upgrade/linos2/" + directory_name + "/" + file_name);
                                    if (fpath.exists()) {
                                        foundFiles = new String[]{file_name};
                                        Trace.trace(TRACE_MASKF, "found files[0] is " + foundFiles[0]);
                                    } else {
                                        Trace.trace(TRACE_MASKF, "File /mnt/upgrade/linos2/" + directory_name + "/" + file_name + " does not exist");
                                        foundFiles[0] = "none";
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, " Global * found. Make a list of files for directory " + directory_name);
                                    fpath = new File("/mnt/upgrade/linos2/" + directory_name);
                                    foundFiles = fpath.list();
                                }
                                Trace.trace(TRACE_MASKF, " Number of files found in directory " + directory_name + " is " + foundFiles.length);
                                if (!foundFiles[0].equals("none")) {
                                    break block41;
                                } else {
                                    Trace.trace(TRACE_MASKF, "FoundFile[0] is none");
                                    continue;
                                }
                            }
                            Trace.trace(TRACE_MASKF, "Sub directory /mnt/upgrade/linos2/" + directory_name + " does not exist");
                            continue;
                        }
                        for (int i1 = 0; i1 < foundFiles.length; ++i1) {
                            Trace.trace(TRACE_MASKF, "Found file : /mnt/upgrade/linos2/" + foundFiles[i1]);
                            Trace.trace(TRACE_MASKF, "foundfiles[i1] is : " + foundFiles[i1]);
                            fullFileName = "/mnt/upgrade/linos2/" + directory_name + "/" + foundFiles[i1];
                            Trace.trace(TRACE_MASKF, "fullFileName is [" + fullFileName + "].");
                            Trace.trace(TRACE_MASKF, "Open File Input Stream" + fullFileName);
                            FileInputStream userStreamIn = new FileInputStream(fullFileName);
                            Trace.trace(TRACE_MASKF, "FileInputStream stream " + fullFileName + " created");
                            Trace.trace(TRACE_MASKF, "Call restoreUpgrade data to restore user data");
                            try {
                                userClass.restoreUpgradeData(userStreamIn, foundFiles[i1]);
                                Trace.trace(TRACE_MASKF, "Return from restoreUpgradeData to restore data from input Stream.");
                                fileTrace.write("Data read from " + fullFileName + " successfully.\n");
                            }
                            catch (UpgradeDataException e) {
                                Trace.trace(TRACE_MASKF, "UpgradeDataExecption was thrown: " + e);
                                fileTrace.write("UpgradeData Exception on " + fullFileName + " call\n");
                                if (e.isCriticalDataError()) {
                                    Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                                    fileTrace.write("Critical Data error flag is set\n");
                                    new FrameworkLog(_logInfo, 16561, e).log();
                                    this.critical_error_flag = true;
                                }
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "Exception on call restoreUpgrade data");
                                fileTrace.write("Exception on call restoreUpgrade data\n");
                                this.critical_error_flag = true;
                            }
                            Trace.trace(TRACE_MASKF, "Return from call restoreUpgrade data");
                            Trace.trace(TRACE_MASKF, "Close File Input Stream " + fullFileName);
                            userStreamIn.close();
                            Trace.trace(TRACE_MASKF, "File Input Stream " + fullFileName + " Closed.");
                        }
                    }
                    catch (IllegalAccessException e) {
                        Trace.trace(TRACE_MASKF, "Illegal Access error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16563, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (InvocationTargetException e) {
                        Trace.trace(TRACE_MASKF, "Invocation Target error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16564, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (InstantiationException e) {
                        Trace.trace(TRACE_MASKF, "Instantiation error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16565, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (NoSuchMethodException e) {
                        Trace.trace(TRACE_MASKF, "No such method error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16566, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (ClassNotFoundException e) {
                        Trace.trace(TRACE_MASKF, "Class not found error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16567, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (NoSuchElementException e) {
                        Trace.trace(TRACE_MASKF, "String tokenizer no such element error");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16568, e).log();
                        this.critical_error_flag = true;
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "IO error while running through the table file.");
                        hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16569, e).log();
                        this.critical_error_flag = true;
                    }
                    finally {
                        Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                    }
                } while (line != null);
                Trace.trace(TRACE_MASKF, "Close trace file.");
                fileTrace.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Caught IO Exception in restoreupgradeHarddrive()" + e);
                status = 15;
                new FrameworkLog(_logInfo, 16572, e).log();
                Object var28_35 = null;
                if (this.critical_error_flag) {
                    Trace.trace(TRACE_MASKF, "critical_error flag set.");
                    status = 15;
                }
                Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataTasklet.restoreupgradeHarddrive()");
                Trace.trace(TRACE_MASKF, "Returned status = " + status);
            }
            Object var28_34 = null;
            if (this.critical_error_flag) {
                Trace.trace(TRACE_MASKF, "critical_error flag set.");
                status = 15;
            }
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataTasklet.restoreupgradeHarddrive()");
            Trace.trace(TRACE_MASKF, "Returned status = " + status);
        }
        catch (Throwable throwable) {
            Object var28_36 = null;
            if (this.critical_error_flag) {
                Trace.trace(TRACE_MASKF, "critical_error flag set.");
                status = 15;
            }
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataTasklet.restoreupgradeHarddrive()");
            Trace.trace(TRACE_MASKF, "Returned status = " + status);
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataRestoreOS2.restoreOS2UpgradeData()");
        return status;
    }
}

